﻿/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
 © i-net software 1998-2013

*/
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Inet.Viewer.Data;

namespace Inet.Viewer.WinForms.Export
{
    /// <summary>
    /// Settings panel for PDF export.
    /// </summary>
    public partial class PDFSettingsControl : FormatSettingsControl
    {
        private const string PropPDFNavigation = "navview";
        private const string PropPDFA = "pdfa";
        private const string PropFastWebView = "fastwebview";
        private const string PropPDFEncryption = "pdfencryption";
        private const string PropPDFOwnerPassword = "opass";
        private const string PropPDFUserPassword = "upass";
        private const string PropPDFTags = "pdftags";

        /// <summary>
        /// Creates the panel.
        /// </summary>
        public PDFSettingsControl()
        {
            InitializeComponent();
            cbNavigation.SelectedIndex = 0;
            cbTags.SelectedIndex = 0;
        }

        /// <inheritdoc />
        public override Bitmap Icon { get { return FormatResource.pdf_48; } }

        /// <inheritdoc />
        public override string Label { get { return "PDF"; } }

        /// <inheritdoc />
        public override string FileSuffix { get { return "pdf"; } }

        /// <inheritdoc />
        public override void CollectExportParameters(Dictionary<string, string> exportParams)
        {
            exportParams[URLRenderData.ParameterExportFmt] = ReportInfo.FormatPDF;
            switch(cbNavigation.SelectedIndex) {
                case 1:  
                    exportParams[PropPDFNavigation] = "pages";
                    break;
                case 2:
                    exportParams[PropPDFNavigation] = "bookmarks";
                    break;
            }
            exportParams[PropPDFA] = chbPDFA.Checked ? URLRenderData.ValueTrue : URLRenderData.ValueFalse;
            exportParams[PropFastWebView] = chbLinear.Checked ? URLRenderData.ValueTrue : URLRenderData.ValueFalse;
            if (chbEncrypt.Checked)
            {
                exportParams[PropPDFEncryption] = URLRenderData.ValueTrue;
                exportParams[PropPDFOwnerPassword] = tbOwnerPasswd.Text;
                exportParams[PropPDFUserPassword] = tbUserPasswd.Text;
            }
            switch (cbTags.SelectedIndex)
            {
                case 1:
                    exportParams[PropPDFTags] = URLRenderData.ValueTrue;
                    break;
                case 2:
                    exportParams[PropPDFTags] = URLRenderData.ValueFalse;
                    break;
            }
        }

        /// <summary>
        /// Called when a checkbox state was changed. Enables/Disables the
        /// corresponding text boxes and other checkboxes.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void chb_CheckedChanged(object sender, EventArgs e)
        {
            tbUserPasswd.Enabled = chbEncrypt.Checked;
            tbOwnerPasswd.Enabled = chbEncrypt.Checked;
            labelUserPasswd.Enabled = chbEncrypt.Checked;
            labelOwnerPasswd.Enabled = chbEncrypt.Checked;

            chbEncrypt.Enabled = !chbPDFA.Checked;
            chbLinear.Enabled = !chbPDFA.Checked;
            chbPDFA.Enabled = !chbEncrypt.Checked && !chbLinear.Checked;
        }
    }
}
